define([
    'underscore',
    'jquery',
    'marionette',
    'modules/appointments/appointments-module',
    'modules/form/section-view',
    'json!modules/new-appointment-request/views/direct/new-appointment-form.json',
    'modules/new-appointment-request/views/direct/clinics/single-clinic-view',
    'modules/new-appointment-request/views/direct/clinics/section-view',
    'modules/new-appointment-request/resources/direct/clinics/collection',
    'modules/new-appointment-request/resources/direct/custom-messages/model',
], function(
    _,
    $,
    Marionette,
    appointmentsModule,
    SectionView,
    metadata,
    SingleClinicView,
    ClinicsSectionView,
    Collection,
    CustomMessageModel
) {
    'use strict';

    return Marionette.View.extend({
        template: _.template("<div class='new-appointment-clinic-container'></div>"),

        regions: {
            containerRegion: '.new-appointment-clinic-container',
        },

        initialize: function(options) {
            this.customMessages = options.customMessages;
            this.collection = options.clinicsCollection || new Collection();
            this.customMessage = new CustomMessageModel();
        },

        onRender: function() {
            var typeOfCareId = this.model.getCareId();
            var institution = this.model.get('facility');
            var institutionCode = institution.get('institutionCode');
            var rootStationCode = institution.get('rootStationCode');
            var data;
            var message;
            var showClinics;

            if (this.collection && this.collection.length) {
                data = new $.Deferred();
                data.resolve();
            } else {
                data = this.collection.fetchClinics(rootStationCode, institutionCode, typeOfCareId);
            }

            message = this.customMessage.fetchClinicMessage(this.model.getInstitutionCode());
            showClinics = _.bind(this.showClinics, this);

            $.when(data, message).done(showClinics);
        },

        /**
         * @return {void}
         */
        showClinics: function() {
            var length = this.collection.length;
            if (length === 0) {
                this.triggerMethod('no:clinics:found');
            } else if (this.collection.length === 1) {
                this._showSingleClinicView();
            } else {
                this._showMultipleClinicView();
            }
        },

        getTimeSlots: function(clinicId) {
            // TODO ... how else can this happen without directly
            // TODO ... invoking a function in child view.
            var view = this.getChildView('containerRegion');
            return view.getTimeSlots(clinicId);
        },

        _showSingleClinicView: function() {
            var clinic = this.collection.first();
            var slots = clinic.get('appointmentTimeSlot');

            var data = this.model.toJSON();

            if (slots) {
                _.extend(data, {
                    clinicId: clinic.id,
                    clinic: {
                        id: clinic.id,
                        name: clinic.get('clinicName'),
                    },
                });
            }

            this.showChildView('containerRegion', new SingleClinicView({
                className: slots ? '' : 'static-text-disabled',
                model: this.model,
                clinicsTimeSlotsModel: clinic,
                clinicCustomMessage: this.customMessage,
            }));
        },

        _showMultipleClinicView: function() {
            this.showChildView('containerRegion', new ClinicsSectionView({
                model: this.model,
                clinicsCollection: this.collection,
                clinicCustomMessage: this.customMessage,
            }));
        },
    });
});
